/*==============================================================================
*  Labor market series for Sweden
*=============================================================================*/
clear all
set more off

cd "$insheet_files/Sweden"

*===============================================================================
* I. Total Population 
*===============================================================================
import excel using "SE_POP_1970_2011", first sheet("BE0101N1 Processed") clear

drop region_name
reshape long y, i(nuts) j(year)
rename y POP

tempfile pop_nuts3
save `pop_nuts3.dta'

gen nuts2 = substr(nuts,1,4) 

collapse (sum) POP, by(nuts2 year)

rename nuts2 nuts
tempfile pop_nuts2
save `pop_nuts2.dta'

gen nuts1 = substr(nuts,1,3) 

collapse (sum) POP, by(nuts1 year)

rename nuts1 nuts
tempfile pop_nuts1
save `pop_nuts1.dta'

gen country=substr(nuts,1,2)

collapse (sum) POP, by(country year)

rename country nuts

append using `pop_nuts1.dta'
append using `pop_nuts2.dta'
append using `pop_nuts3.dta'

replace POP = POP/1000
rename POP POP_SE

tempfile SE_POP
save `SE_POP.dta'

*===============================================================================
*						II. Population, ages 16-75
* Source: data from  Swedish statistical office web database (1970-1975)
* Note: These data will be used to multiply by lfpr & ue_rate prior to 1976
*===============================================================================

foreach sex in males females {
	import excel using "SE_POP_by_age_1970_1975.xls", first cellrange(A1:H22) ///
	sheet("WAP_1970_1975_Processed_`sex'") clear

	drop region_name
	reshape long y, i(nuts) j(year)
	rename y WAP_b4_1976_`sex'

	gen nuts2 = substr(nuts,1,4) 

	collapse (sum) WAP, by(nuts2 year)

	rename nuts2 nuts

	replace WAP = WAP/1000
	rename WAP WAP_1970_1975_`sex'_se

	tempfile se_WAP_`sex'
	save `se_WAP_`sex'.dta'
	clear
}

use `se_WAP_males.dta'
merge 1:1 nuts year using `se_WAP_females.dta', nogen assert(3)

egen WAP_1971_1975 = rsum(WAP*) 
drop *male* *female*

keep if year>=1971 & year<=1975

tempfile SE_WAP_1971_1975
save `SE_WAP_1971_1975.dta'

*===============================================================================
*						III. Population, ages 16-64
* Source: data from  Swedish statistical office web database. 
* Note: These data will be used to multiply by lfpr & ue_rate 1976-2011
*===============================================================================

import excel using "SE_AKU_1976_2007.xlsx", first sheet("POP 16-64 processed") clear

drop C 
reshape long y, i(nuts region_name) j(year)
rename y WAP

replace WAP = WAP/1000
rename WAP WAP_post1975

keep if year>=1976 & year<=2007
	
tempfile SE_WAP_1976_2011
save `SE_WAP_1976_2011.dta'

*===============================================================================
*					IV. Unemployment and activity rates
* Source: data from  Swedish statistical office (direct email)	pdf file 
* covering 1976-2011
*===============================================================================

import excel using "SE_AKU_1976_2007.xlsx", first sheet("AM0401N1 processed") clear

drop C 

reshape long y, i(nuts region_name variable) j(year)
reshape wide y, i(nuts region_name year) j(variable) string

rename yLFPR 	LFPR_AKU_SE
rename yue_rate ue_rate_AKU_SE

merge 1:1 nuts year using `SE_WAP_1976_2011.dta', nogen

gen LF_AKU_SE	  	= LFPR_AKU_SE/100*WAP
gen UNEMP_AKU_SE 	= ue_rate_AKU_SE/100*LF_AKU_SE
gen EMP_AKU_SE		= LF_AKU_SE-UNEMP_AKU_SE

keep year nuts region_name UNEMP LF_ EMP 

tempfile SE_AKU_post1975_nuts3
save `SE_AKU_post1975_nuts3.dta'

gen nuts2 = substr(nuts,1,4) 

collapse (sum) UNEMP LF EMP , by(nuts2 year)

rename nuts2 nuts
tempfile SE_AKU_post1975_nuts2
save `SE_AKU_post1975_nuts2.dta'

gen nuts1 = substr(nuts,1,3) 

collapse (sum) UNEMP LF EMP, by(nuts1 year)

rename nuts1 nuts
tempfile SE_AKU_post1975_nuts1
save `SE_AKU_post1975_nuts1.dta'

gen country=substr(nuts,1,2)

collapse (sum) UNEMP LF EMP, by(country year)

rename country nuts

append using `SE_AKU_post1975_nuts1.dta'
append using `SE_AKU_post1975_nuts2.dta'	
append using `SE_AKU_post1975_nuts3.dta'

tempfile SE_labor_1976_2011
save 	`SE_labor_1976_2011.dta'

*===============================================================================
* V. Unemployment and activity rates, 1971-1975
* Source: Statistiska meddelanden
*===============================================================================

import excel using "SE_AKU_1971_1975", first clear 

merge 1:1 nuts year using `SE_WAP_1971_1975.dta', nogen

rename LFPR 	LFPR_AKU_SE
rename ue_rate 	ue_rate_AKU_SE

gen LF_AKU_SE		= LFPR_AKU_SE/100*(WAP_1971_1975)
gen UNEMP_AKU_SE	= ue_rate_AKU_SE/100*LF_AKU_SE
gen EMP_AKU_SE		= LF_AKU_SE-UNEMP_AKU_SE

keep year nuts region_name LF_ EMP UNEMP 

tempfile SE_AKU_post1975_nuts2
save `SE_AKU_post1975_nuts2.dta'

gen nuts1 = substr(nuts,1,3) 

collapse (sum) LF EMP UNEMP, by(nuts1 year)

rename nuts1 nuts
tempfile SE_AKU_post1975_nuts1
save `SE_AKU_post1975_nuts1.dta'

gen country=substr(nuts,1,2)

collapse (sum)  LF EMP UNEMP, by(country year)

rename country nuts

append using `SE_AKU_post1975_nuts1.dta'
append using `SE_AKU_post1975_nuts2.dta'	

*===============================================================================
* VI. Merge all SE data
*===============================================================================

append using `SE_labor_1976_2011.dta'
merge 1:1 nuts year using `SE_POP.dta', nogen

label var LF_AKU_SE 	"Labor force, Sweden, Labor force survey"
label var EMP_AKU_SE 	"Employed, Sweden, Labor force survey"
label var UNEMP_AKU_SE 	"Unemployed, Sweden, Labor force survey"
label var POP_SE 	"Population, Sweden, Swedish statistical office" 

sort nuts year
save "$dta_files/SE_labor", replace

